# import json
from bpy.types import Panel
from os.path import join, exists
from ...addon.paths import FluidLabPaths
# from ...addon.naming import FluidLabNaming
from ..ui_module_panel import FLUIDLAB_ModulePanel
from ...libs.functions.libraries import read_fluid_preset
# from ...addon.preferences import FluidLabAddonPreferences
from ...libs.functions.get_common_vars import get_common_vars
# from ...libs.functions.nodes import get_node_index_or_identifier_by
from ...libs.functions.common_ui_elements import title_header


class FLUIDLAB_PT_fluid_presets(Panel, FLUIDLAB_ModulePanel):
    fluidlab_section = 'FLUID_PRESETS'
    bl_idname = "FLUIDLAB_PT_fluid_presets_ui"
    bl_label = "Module"


    def draw(self, context):

        fluid_presets, ui = get_common_vars(context, get_fluid_presets=True, get_ui=True)
        
        layout = self.layout
        layout.use_property_split = True
        layout.use_property_decorate = False

        col = layout.column(align=True)
        title_header(col, "Fluid Presets")

        main_col = col.box().column(align=True)
        main_col.use_property_split = True
        main_col.use_property_decorate = False

        if ui.ui_mode == 'BASIC':
        
            # ------------- #
            """ UI BASICA """
            # ------------- #
        
            main_col.label(text="Hola Mundo Basico")

    
        elif ui.ui_mode == 'ADVANCED':
        
            # --------------- #
            """ UI AVANZADA """
            # --------------- # 


            default_path = join(FluidLabPaths.LIBS, "fluid_presets")
            if exists(default_path):

                main_col.separator()
                table = main_col.column(align=True)
    
                preset = table.row(align=True)
                preset.scale_y = 1.3
                preset.use_property_split = False

                # choose preset
                preset.prop(fluid_presets, "presets", text="")
                
                # Add new preset
                add_p = preset.row(align=True) 
                add_p.enabled = not fluid_presets.edit_preset
                add_p.operator("fluidlab.fluid_new_preset", icon='ADD', text="")
                                
                # Edit
                preset.prop(fluid_presets, "edit_preset", toggle=True, icon='GREASEPENCIL', text="")

                # Save
                if fluid_presets.edit_preset:
                    preset.operator("fluidlab.fluid_save_presets", icon='DISK_DRIVE', text="")
                
                # Remove
                if not fluid_presets.edit_preset:
                    remove = preset.row(align=True)
                    remove.alert = True
                    remove.operator("fluidlab.fluid_preset_remove", icon='TRASH', text="")

                preset.separator()

                # Apply preset
                apply_p = preset.row(align=True)
                apply_p.enabled = not fluid_presets.edit_preset
                apply_p.operator("fluidlab.fluid_presets_set", text="Set Preset")

                row_te = table.row(align=True)
                row_te.use_property_split = False
                row_te.scale_y = 1.3


                # -------------------------------------------------------------------------------------------

                # UI que muestra el preset leido del json:

                def header_settings(layout, label:str) -> None:
                    col = layout.box().column(align=True)
                    header = col.row(align=True)
                    header.alignment = 'CENTER'
                    header.label(text=label)                   

                filename = fluid_presets.presets.lower() + ".json"
                file = join(default_path, filename)
                
                # El data de los json:
                emission_data = read_fluid_preset(context, filename, file, "emission_props")
                physics_data = read_fluid_preset(context, filename, file, "physics_props")
                springs_data = read_fluid_preset(context, filename, file, "springs_props")

                def print_ui_data(layout, data_dict):
                    layout = layout.box().column(align=True)
                    layout.enabled = fluid_presets.edit_preset
                    for slug in data_dict.keys():
                        row = layout.row(align=True)
                        row.prop(fluid_presets, slug)

                table.separator()
                
                if emission_data:
                    header_settings(table, "Emission Settings")
                    print_ui_data(table, emission_data)
                    table.separator()

                if physics_data:
                    header_settings(table, "Physics Settings")
                    print_ui_data(table, physics_data)
                    table.separator()

                if springs_data:
                    header_settings(table, "Springs Settings")
                    print_ui_data(table, springs_data)
